% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findThoughts.R
\name{make.dt}
\alias{make.dt}
\title{Make a \code{data.table} of topic proportions.}
\usage{
make.dt(model, meta = NULL)
}
\arguments{
\item{model}{The \code{stm} model.}

\item{meta}{Optionally, the metadata object passed to the \code{stm} model.}
}
\description{
Combines the document-topic loadings (theta) with metadata to create a \code{data.table} object for easy querying.
}
\details{
This is a simple utility function that creates a \pkg{data.table} object which you can use to create 
more complicated queries than via \code{\link{findThoughts}}.  Topics are named via the convention 
\code{Topic#}, for example \code{Topic1}, \code{Topic2} etc.  The object also contains \code{docnum}
which gives the index of the document so you can set keys without worrying about the texts getting
disconnected.

We expect that for the vast majority of users the functionality in \code{\link{findThoughts}} will be
sufficient.
}
\examples{
dt <- make.dt(gadarianFit, meta=gadarian)
#now we can do any query.  For example the 5 least associated documents with Topic 2 in
#the treated group
dt[treatment==0, docnum[order(Topic2, decreasing=FALSE)][1:5]]

}
\seealso{
\code{\link{findThoughts}}
}

