% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCorpus.R
\name{readCorpus}
\alias{readCorpus}
\title{Read in a corpus file.}
\usage{
readCorpus(corpus, type = c("dtm", "slam", "Matrix"))
}
\arguments{
\item{corpus}{An input file or filepath to be processed}

\item{type}{The type of input file.  We offer several sources, see details.}
}
\value{
\item{documents}{A documents object in our format} \item{vocab}{A
vocab object if information is available to construct one}
}
\description{
Converts pre-processed document matrices stored in popular formats to stm
format.
}
\details{
This function provides a simple utility for converting other document
formats to our own.  Briefly- \code{dtm} takes as input a standard matrix
and converts to our format.   \code{slam} converts from the
\code{simple_triplet_matrix} representation used by the \code{slam} package.
This is also the representation of corpora in the popular \code{tm} package
and should work in those cases.

\code{dtm} expects a matrix object where each row represents a document and
each column represents a word in the dictionary.

\code{slam} expects a \code{\link[slam]{simple_triplet_matrix}} from that
package.

\code{Matrix} attempts to coerce the matrix to a
\code{\link[slam]{simple_triplet_matrix}} and convert using the
functionality built for the \code{slam} package.  This will work for most
applicable classes in the \code{Matrix} package such as \code{dgCMatrix}.

If you are trying to read a \code{.ldac} file see \code{\link{readLdac}}.
}
\examples{

\dontrun{

library(textir)
data(congress109)
out <- readCorpus(congress109Counts, type="Matrix")
documents <- out$documents
vocab <- out$vocab
}
}
\seealso{
\code{\link{textProcessor}}, \code{\link{prepDocuments}} \code{\link{readLdac}}
}
