% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{checkResiduals}
\alias{checkResiduals}
\title{Residual dispersion test for topic number}
\usage{
checkResiduals(stmobj, documents, tol = 0.01)
}
\arguments{
\item{stmobj}{An \code{STM} model object for which to compute residuals.}

\item{documents}{The documents corresponding to \code{stmobj} as in
\code{\link{stm}}.}

\item{tol}{The tolerance parameter for calculating the degrees of freedom.
Defaults to 1/100 as in Taddy(2012)}
}
\description{
Computes the multinomial dispersion of the STM residuals as in Taddy (2012)
}
\details{
This function implements the residual-based diagnostic method of Taddy
(2012).  The basic idea is that when the model is correctly specified the
multinomial likelihood implies a dispersion of the residuals:
\eqn{\sigma^2=1}.  If we calculate the sample dispersion and the value is
greater than one, this implies that the number of topics is set too low,
because the latent topics are not able to account for the overdispersion. In
practice this can be a very demanding criterion, especially if the documents
are long.  However, when coupled with other tools it can provide a valuable
perspective on model fit. The function is based on the Taddy 2012 paper as well as code
found in maptpx package.

Further details are available in the referenced paper, but broadly speaking
the dispersion is derived from the mean of the squared adjusted residuals.
We get the sample dispersion by dividing by the degrees of freedom
parameter.  In estimating the degrees of freedom, we follow Taddy (2012) in
approximating the parameter \eqn{\hat{N}} by the number of expected counts
exceeding a tolerance parameter.  The default value of 1/100 given in the
Taddy paper can be changed by setting the \code{tol} argument.

The function returns the estimated sample dispersion (which equals 1 under
the data generating process) and the p-value of a chi-squared test where the
null hypothesis is that \eqn{\sigma^2=1} vs the alternative \eqn{\sigma^2
>1}. As Taddy notes and we echo, rejection of the null 'provides a very
rough measure for evidence in favor of a larger number of topics.'
}
\examples{

#An example using the Gadarian data.  From Raw text to fitted model.
temp<-textProcessor(documents=gadarian$open.ended.response,metadata=gadarian)
meta<-temp$meta
vocab<-temp$vocab
docs<-temp$documents
out <- prepDocuments(docs, vocab, meta)
docs<-out$documents
vocab<-out$vocab
meta <-out$meta
set.seed(02138)
#maximum EM iterations set very low so example will run quickly.  
#Run your models to convergence!
mod.out <- stm(docs, vocab, 3, prevalence=~treatment + s(pid_rep), data=meta,
               max.em.its=5)
checkResiduals(mod.out, docs)
}
\references{
Taddy, M. 'On Estimation and Selection for Topic Models'.
AISTATS 2012, JMLR W&CP 22
}
