% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STMfunctions.R
\name{calclift}
\alias{calclift}
\title{Calculate Lift Words}
\usage{
calclift(logbeta, wordcounts)
}
\arguments{
\item{logbeta}{a K by V matrix containing the log probabilities of seeing word v conditional on topic k}

\item{wordcounts}{a V length vector indicating the number of times each word appears in the corpus.}
}
\description{
A primarily internal function for calculating words according to the lift metric.
We expect most users will use \code{\link{labelTopics}} instead.
}
\details{
Lift is the calculated by dividing the topic-word distribution by the empirical
word count probability distribution.  In other words the Lift for word v in topic
k can be calculated as:

\deqn{Lift = \beta_{k,v}/(w_v/\sum_v w_v)}{Lift = \beta/wbar} 

We include this after seeing it used effectively in Matt Taddy's work including his
excellent \pkg{maptpx} package. Definitions are given in Taddy(2012).
}
\references{
Taddy, Matthew. 2012. "On Estimation and Selection for Topic Models." AISTATS JMLR W&CP 22
}
\seealso{
\code{\link{labelTopics}}
}
\keyword{internal}
