% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_similar_stories.r
\name{get_similar_stories}
\alias{get_similar_stories}
\title{Recommend stories similar to a user-selected one.}
\usage{
get_similar_stories(
  mystory,
  background_storyset = c("tos", "tas", "tng", "voy"),
  theme_levels = c("central", "peripheral"),
  similarity_function = c("cosine", "cosine tf-idf", "soft cardinality"),
  blacklist = ""
)
}
\arguments{
\item{mystory}{A story class object.}

\item{background_storyset}{default \code{c("tos", "tas", "tng", "voy")}. A string indicating the storyset to use as background.
Possible values are \code{c("tos", "tas")}, \code{"tng"}, \code{"voy"}, and \code{c("tos", "tas", "tng", "voy")}.}

\item{theme_levels}{default \code{c("central", "peripheral")}. A string indicating the theme levels to use in the analysis.
Possible values are \code{"central"}, \code{"peripheral"}, and \code{c("central", "peripheral")}.}

\item{similarity_function}{default "cosine". 
Possible values are \code{"cosine"}, \code{"cosine tf-idf"}, and \code{c("soft cardinality")}.}

\item{blacklist}{default \code{""}. A vector of blacklisted themes.}
}
\value{
Returns a data frame where each row corresponds to a story.
The column SimilarityScore contains scores indicating story similarity to the selected story.
}
\description{
\code{get_similar_stories} returns a list of stories,
sorted by thematic similarity with respect to a user-selected story
}
\examples{
#######################################################################
# Recommend Star Trek stories similar to the Star Trek: Voyager       #
# episode False Profits (voy3x05)                                     #
#######################################################################
\dontrun{story_id <- "voy3x05"
mystory <- story$new(story_id)
result <- get_similar_stories(mystory)}

#######################################################################
# Output top ten most similar stories                                 #
#######################################################################
\dontrun{result[1:10,]}
}
\references{
Sheridan, P., Onsjö, M., and Jiménez, S. (2018): 
"A Content-based Filtering Story Recommender System for Theme Lovers with an Application to the Star Trek Television Franchise", 
ArXiv.
}
