% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lto.R
\name{fetch_lto_file}
\alias{fetch_lto_file}
\title{Download LTO JSON files to cache}
\usage{
fetch_lto_file(file_name, verbose = TRUE, overwrite_json = FALSE)
}
\arguments{
\item{verbose}{A logical value indicating whether status messages should be
output to console.}

\item{overwrite_json}{A logical value indicating whether previously
downloaded JSON files (if any) should be re-downloaded and overwritten.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{fetch_lto_file()} downloads \acronym{LTO} version JSON files hosted on
the Theme Ontology website at \url{https://www.themeontology.org/data}
to cache.
}
\details{
This function is called internally by the \code{configure_lto()}
package function. Use it directly at your own risk.
}
\examples{
\dontrun{
# Download and cache an LTO developmental version JSON file:
fetch_lto_file(file_name = "lto-dev-collections.json", overwrite_json = TRUE)
}
}
\keyword{internal}
