% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_svdraws.R
\name{arpredict}
\alias{arpredict}
\title{Dynamic prediction for the AR-SV model (deprecated)}
\usage{
arpredict(object, volpred)
}
\arguments{
\item{object}{\code{svdraws} object as returned from \code{\link{svsample}}.}

\item{volpred}{\code{svpredict} object as returned from
\code{\link{predict.svdraws}}.}
}
\value{
Returns an object of class \code{c("distpredict", "mcmc")}
containing simulations from the posterior predictive density of
\code{y_(n+1),...,y_(n+steps)}.
}
\description{
Simulates draws from the posterior predictive density of a fitted AR-SV
model.
DEPRECATED: please use \code{predict.svdraws} on \code{svdraws} objects
resulting from model estimation with an autoregressive mean structure.
}
\note{
You can use the usual \code{coda} methods for \code{mcmc} objects to
print, plot, or summarize the predictions.
}
\examples{
\dontrun{
data(exrates)
y <- exrates$USD

## Fit AR(1)-SV model to EUR-USD exchange rates
res <- svsample(y, designmatrix = "ar1")

## Use predict.svdraws to obtain predictive volatilities
ahead <- 100
preds <- predict(res, steps = ahead)
predvol <- preds$h
class(predvol) <- "svpredict"

## Use arpredict to obtain draws from the posterior predictive
preddraws <- arpredict(res, predvol)

## Calculate predictive quantiles
predquants <- apply(preddraws, 2, quantile, c(.1, .5, .9))

## Visualize
ts.plot(y, xlim = c(length(y) - ahead, length(y) + ahead),
	ylim = range(predquants))
for (i in 1:3) {
 lines((length(y) + 1):(length(y) + ahead), predquants[i,],
       col = 3, lty = c(2, 1, 2)[i])
}
}
}
\seealso{
\code{\link{predict.svdraws}}.
}
\author{
Gregor Kastner \email{gregor.kastner@wu.ac.at}
}
\keyword{ts}
