\name{ex}
\alias{ex}
\alias{ey}
\alias{ez}
\docType{data}
\title{Basis vectors in three-dimensional space}
\description{

Objects \code{ex}, \code{ey} and \code{ez} are the three elementary
one-forms on three-dimensional space, sometimes denoted
\eqn{(e_x,e_y,e_z)}.  These objects can be generated by running
script \file{vignettes/ex.Rmd}, which includes some further discussion
and technical documentation and creates file \file{exeyez.rda} which
resides in the \code{data/} directory.
}
\details{See vignettes \code{dx} and \code{ex} for an extended
  discussion; a use-case is given in \code{vector_cross_product}.}
\references{
  \itemize{\item M. Spivak 1971. \emph{Calculus on manifolds},
  Addison-Wesley}
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{d}},\code{\link{print.kform}}}
\examples{

as.function(dx)(ex)

(X <- as.kform(matrix(1:12,nrow=4),c(1,2,7,11)))
as.function(X)(cbind(e(2,12),e(6,12),e(10,12)))

}
\keyword{datasets}
