% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.stcov.R
\name{summary.stcov}
\alias{summary.stcov}
\title{Summary of a \code{stcov} object}
\usage{
\method{summary}{stcov}(object, ...)
}
\arguments{
\item{object}{An object of class \code{stcov}}

\item{...}{additional unused argument}
}
\description{
It prints the summary statistics of the spatio-temporal coordinates and the 
covariates values
of  the spatio-temporal covariate
stored in the \code{stcov} object.
}
\examples{

\dontrun{
set.seed(2)
df <- data.frame(runif(100), runif(100), runif(100), rpois(100, 15))

cov <- stcov(df, interp = FALSE)
summary(cov)
}

}
\author{
Nicoletta D'Angelo
}
