% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.stp.R
\name{plot.stp}
\alias{plot.stp}
\title{Plot a \code{stp} object}
\usage{
\method{plot}{stp}(x, tcum = TRUE, marg = TRUE, col = 1, ...)
}
\arguments{
\item{x}{An object of class \code{stp}}

\item{tcum}{If \code{TRUE} (default option),
the temporal point pattern is displayed cumulatively.
A barplot is automatically plotted if there are repeated
counts (typically with discrete times).}

\item{marg}{Default to \code{TRUE}. If \code{FALSE}, only the
spatio-temporal point pattern is plotted.}

\item{col}{The color of the points. Default to \code{"black"}}

\item{...}{additional unused argument}
}
\description{
This function plots the point pattern stored in the stp object given in input,
in a three panel plot representing the 3Dplot of the coordinates, and the
marginal spatial and temporal coordinates.
}
\examples{


set.seed(2)
df <- data.frame(cbind(runif(100), runif(100), runif(100)))

stp1 <- stp(df)
#plot
plot(stp1)

#cumulative time occurrances
plot(stp1, tcum = FALSE)

#change color of points
plot(stp1, col = "blue")

#display only in space-time
plot(stp1, marg = FALSE)

#discrete times
set.seed(2)
stp2 <- stp(data.frame(cbind(runif(100), runif(100), round(runif(100) * 100))))
plot(stp2)


}
\seealso{
\link{stp}, \link{print.stp}, \link{summary.stp}
}
\author{
Nicoletta D'Angelo
}
