% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findconst.R
\name{findconst}
\alias{findconst}
\title{Search for Calibration Value}
\usage{
findconst(ns, p0, type, alpha, l, u, iter = 50, param)
}
\arguments{
\item{ns}{A vector of sample sizes at which sequential testing is performed}

\item{p0}{The toxicity rate under the null hypothesis}

\item{type}{The method used for constructing the stopping rule}

\item{alpha}{The desired type I error / false positive rate for the stopping rule}

\item{l}{Lower starting value of bracket for calibration constant}

\item{u}{Upper starting value of bracket for calibration constant}

\item{iter}{The number of iterations used to search for the boundary}

\item{param}{Extra parameter(s) needed for certain stopping rule methods. For binomial Wang-Tsiatis tests, this is the Delta parameter. For Bayesian beta-binomial model, this is the pair of hyperparameters for the beta prior on the toxicity rate. For modified SPRT, this is the targeted alternative toxicity rate p1.}
}
\value{
The calibration constant used for subsequent stopping boundary calculation
}
\description{
Internal workhorse function to calculate the calibration constant value that attains level alpha for given method
}
