% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.rule.surv.R
\name{table.rule.surv}
\alias{table.rule.surv}
\title{Tabulate Stopping Rule (Survival data)}
\usage{
table.rule.surv(rule, dec = 0)
}
\arguments{
\item{rule}{A 'rule.surv' object calculated by \code{calc.rule.surv()} function}

\item{dec}{Number of decimal places to which the stagewise total follow-up times should be rounded}
}
\value{
A matrix with two columns: total follow up time and their corresponding rejection boundary
}
\description{
Summarize a stopping rule in a condensed tabular format
}
\examples{
pocock.rule <- calc.rule.surv(n = 30, p0 = 0.1, alpha = 0.05, tau = 100, type = "Pocock")
table.rule.surv(pocock.rule)
}
