% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.rule.bin.R
\name{table.rule.bin}
\alias{table.rule.bin}
\title{Tabulate Stopping Rule (Binary Data)}
\usage{
table.rule.bin(x)
}
\arguments{
\item{x}{A \code{rule.bin} object calculated by \code{calc.rule.bin()} function}
}
\value{
A matrix with two columns: the ranges of evaluable patients, and corresponding rejection boundaries for these ranges
}
\description{
Summarize a stopping rule in a condensed tabular format
}
\examples{
# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity probability of 20\%
poc_rule = calc.rule.bin(ns=1:50,p0=0.20,alpha=0.10,type="Pocock")

# Tabulate stopping boundary
table.rule.bin(poc_rule)
}
