% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_conversions.R
\name{gradient_to_surface}
\alias{gradient_to_surface}
\title{Calculate surface wind speed from gradient}
\usage{
gradient_to_surface(wind_gl_aa, cdist)
}
\arguments{
\item{wind_gl_aa}{A numerical value with estimated gradient-level wind speed
(m / s) at a grid point.}

\item{cdist}{A numerical value with radius from the storm center to the grid
point, in kilometers.}
}
\value{
A numeric vector with the estimated symmetric surface wind speed at
   the grid point, in meters / second.
}
\description{
Calculates the surface wind speed based on an estimated gradient
wind speed at a point and the radius from the storm center to
the grid point.
}
\details{
The reduction factor is based on Figure 3 of Knaff et al., 2003.
Over water, it is estimated to be 0.9 up to a radius of 100 km,
0.75 for a radius of 700 km or more, and decrease linearly between
a radius of 100 km and 700 km. Points over land should use a reduction
factor that is 20\% lower. Because all of the counties are over
land, the function makes this adjustment for all grid points.
}
\note{
This function is only appropriate to use for points that are over
   land.
}
\references{
Knaff JA, DeMaria M, Molenar DA, Sampson CR, and Seybold MG. 2011. An
automated, objective, multiple-satellite-platform tropical cyclone surface
wind speed analysis. Journal of Applied Meteorology and Climatology
50(10):2149-2166
}
