% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_committees.R
\name{get_session_committees}
\alias{get_session_committees}
\title{Parliamentary committees in specified session}
\usage{
get_session_committees(sessionid = NA, good_manners = 0)
}
\arguments{
\item{sessionid}{Character string indicating the id of the parliamentary session to retrieve.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{id} \tab Committee id \cr
   \strong{name} \tab Committee name \cr
   \strong{session_id} \tab Session id \cr
}
}
\description{
A function for retrieving Norwegian parliamentary committees for a specified parliamentary session
}
\examples{

\dontrun{

coms <- get_session_committees("2001-2002")
coms
}

}
\seealso{
\link{get_all_committees} \link{get_mp_bio} \link{get_mp}
}
