% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs-funs.R
\name{gprojected}
\alias{gprojected}
\title{Perform GIS functions on a temporary, projected version of a spatial object}
\usage{
gprojected(shp, fun, crs = crs_select_aeq(shp), ...)
}
\arguments{
\item{shp}{A spatial object with a geographic (WGS84) coordinate system}

\item{fun}{A function to perform on the projected object (e.g.  \code{\link{gLength}}))}

\item{crs}{An optional coordinate reference system (if not provided it is set
automatically by \code{\link{crs_select_aeq}}).}

\item{...}{Arguments to pass to \code{fun}, e.g. \code{byid = TRUE} if the function is \code{\link{gLength}}))}
}
\description{
Perform GIS functions on a temporary, projected version of a spatial object
}
\examples{
# Find the length of routes that are in lat/long format
data(routes_fast)
rlength = gprojected(routes_fast, fun = rgeos::gLength, byid = TRUE)
plot(routes_fast$length, rlength)
cor(routes_fast$length, rlength)
rbuf = gprojected(routes_fast, rgeos::gBuffer, byid = TRUE, width = 100)
plot(rbuf)
raster::crs(rbuf)
plot(routes_fast, col = "green", add = TRUE)
}

