% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs-funs.R
\name{reproject}
\alias{reproject}
\title{Reproject lat/long spatial object so that they are in units of 1m}
\usage{
reproject(shp, crs = crs_select_aeq(shp))
}
\arguments{
\item{shp}{A spatial object with a geographic (WGS84) coordinate system}

\item{crs}{An optional coordinate reference system (if not provided it is set
automatically by \code{\link{crs_select_aeq}}).}
}
\description{
Many GIS functions (e.g. finding the area)
}
\examples{
data(routes_fast)
rf_aeq = reproject(routes_fast)
rf_osgb = reproject(routes_fast, 27700)
cor(rgeos::gLength(rf_aeq, byid = TRUE), rgeos::gLength(rf_osgb, byid = TRUE))
rf_aeq_wgs84 = sp::spTransform(rf_aeq, CRS("+init=epsg:4326"))
rf_osgb_wgs84 = sp::spTransform(rf_osgb, CRS("+init=epsg:4326"))
plot(rf_aeq_wgs84)
plot(rf_osgb_wgs84, col = "red", add = TRUE)
}

