% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope.R
\name{route_sequential_dist}
\alias{route_sequential_dist}
\title{Calculate the sequential distances between sequential coordinate pairs}
\usage{
route_sequential_dist(m, lonlat = TRUE)
}
\arguments{
\item{m}{Matrix containing coordinates and elevations}

\item{lonlat}{Are the coordinates in lon/lat order? \code{TRUE} by default}
}
\description{
Calculate the sequential distances between sequential coordinate pairs
}
\examples{
x = c(0, 2, 3, 4, 5, 9)
y = c(0, 0, 0, 0, 0, 1)
m = cbind(x, y)
route_sequential_dist(m)
}
\seealso{
Other route_funs: 
\code{\link{route_average_gradient}()},
\code{\link{route_rolling_average}()},
\code{\link{route_rolling_diff}()},
\code{\link{route_rolling_gradient}()},
\code{\link{route_slope_matrix}()},
\code{\link{route_slope_vector}()}
}
\concept{route_funs}
