% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnet_join.R
\name{rnet_subset}
\alias{rnet_subset}
\title{Subset one route network based on overlaps with another}
\usage{
rnet_subset(
  rnet_x,
  rnet_y,
  dist = 10,
  crop = TRUE,
  min_length = 20,
  rm_disconnected = TRUE
)
}
\arguments{
\item{rnet_x}{The route network to be subset}

\item{rnet_y}{The subsetting route network}

\item{dist}{The buffer width around y in meters. 1 m by default.}

\item{crop}{Crop \code{rnet_x}? \code{TRUE} is the default}

\item{min_length}{Segments shorter than this multiple of dist
\emph{and} which were longer
before the cropping process will be removed. 3 by default.}

\item{rm_disconnected}{Remove ways that are}
}
\description{
Subset one route network based on overlaps with another
}
\examples{
rnet_x <- osm_net_example[1]
rnet_y <- route_network_small["flow"]
plot(rnet_x$geometry, lwd = 5)
plot(rnet_y$geometry, add = TRUE, col = "red", lwd = 3)
rnet_x_subset <- rnet_subset(rnet_x, rnet_y)
plot(rnet_x_subset, add = TRUE, col = "blue")
}
