% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psim_real.R
\name{psim_real}
\alias{psim_real}
\title{Stpp from real (sample) origins}
\usage{
psim_real(n_events, ppt, start_date = NULL, poly = NULL,
netw = NULL, s_threshold = NULL, step_length = 20, n_origin=50,
restriction_feat=NULL, field=NA,
p_ratio=20, interactive = FALSE, s_range = 150,
s_interaction = "medium", tolerance = 0.07,
crsys = NULL)
}
\arguments{
\item{n_events}{number of points
(events) to simulate. Default: \code{1000}.
A vector of integer values can be supplied, such as,
c(\code{a}1, \code{a}2, ....)\verb{, where }a\verb{1, }a`2, ...
represent different integer values.}

\item{ppt}{A 3-column matrix or list containing
\code{x} - eastings, \code{y} - northing, and \code{t} - time of occurrence
(in the format: `yyyy-mm-dd')}

\item{start_date}{the start date of the temporal pattern.
The date should be in the format \code{"yyyy-mm-dd"}.
The temporal pattern will normally cover
1-year period.}

\item{poly}{(An sf or S4 object)
a polygon shapefile defining the extent of the landscape}

\item{netw}{(An sf or S4 object)
The network path of the landscape
(e.g. road and/or street). Default: \code{NULL}.
If provided each event is snapped to the closest
network path/segment.}

\item{s_threshold}{defines the spatial
perception range of a walker at a given
location. Default: \code{250} (in the same
linear unit
as the \code{poly} - polygon shapefile).}

\item{step_length}{the maximum step taken
by a walker from one point to the next.}

\item{n_origin}{number of locations to serve as
origins for walkers. Default:\code{50}.}

\item{restriction_feat}{(An S4 object) optional
shapefile containing features
in which walkers cannot walk through.
Default: \code{NULL}.}

\item{field}{a number in the range of \code{[0-1]}
(i.e. restriction values) assigned
to all features; or
the name of a numeric field to extract such
restriction values for different classes of
feature.
Restriction value \code{0} and \code{1} indicate the
lowest and the highest obstructions, respectively.
Default: \code{NULL}.}

\item{p_ratio}{the smaller of the
two terms of proportional ratios.
For example, a value of \code{20}
implies \code{20:80} proportional ratios.}

\item{interactive}{Whether to run the process in
interactive mode. Default is \code{FALSE}. If \code{TRUE},
a user is able to preview the spatial and temporal models
of the expected distribution of the final simulated
events (points).}

\item{s_range}{A value (in metres), not less than 150,
specifying the maximum range of spatial
interaction across the space. For example, for 150m,
the intervals of spatial interactions are created as
\code{(0, 50]}, \code{(50 - 100]}, and \code{(100-150]},
representing the "small", "medium", and "large",
spatial interaction ranges, respectively. If
\code{s_range} is set as \code{NULL}, simulation
focusses only on generating point pattern with
similar spatiotemporal patterns as the sample
dataset.}

\item{s_interaction}{(string) indicating the
type of spatial interaction to detect.
Default: \code{"medium"} (See parameter \code{'s_range'})}

\item{tolerance}{Pvalue to use for the extraction of
space-time interaction in the sample data. Default
value: \code{0.05}.}

\item{crsys}{(string) the EPSG code of the projection
system of the \code{ppt} coordinates. This is only used if
\code{poly} argument is \code{NULL}.
See "http://spatialreference.org/" for the list of
EPSG codes for different regions of the world.
As an example, the EPSG code for the British National Grid
projection system is: \code{"EPSG:27700"}.}
}
\value{
A list of artificial spatiotemporal
point patterns and interaction generated based on a sample
(real) data.
}
\description{
Generates spatiotemporal point pattern
from origins sampled based on real sample dataset.
}
\details{
The spatial and temporal patterns and
interactions detected in sample datasets
are extrapolated to synthetise larger
data size. Details of the spatiotemporal
interactions detected in the sample
dataset are provided. If the street network
of the area is provided, each point is
snapped to its nearest street segment.
}
\examples{
\dontrun{
data(camden_crimes)
#subset 'theft' crime
theft <- camden_crimes[which(camden_crimes$type == "Theft"),]
#specify the proportion of full data to use
sample_size <- 0.3
set.seed(1000)
dat_sample <- theft[sample(1:nrow(theft),
round((sample_size * nrow(theft)), digits=0),
replace=FALSE),1:3]
#plot(dat_sample$x, dat_sample$y) #preview

#load boundary and land use of Camden
#load(file = system.file("extdata", "camden.rda",
#package="stppSim"))
#landuse = camden$landuse # get landuse
landuse <- stppSim:::landuse
#simulate data
simulated_stpp <- psim_real(n_events=2000, ppt=dat_sample,
start_date = NULL, poly = NULL, netw = NULL, s_threshold = NULL,
step_length = 20, n_origin=20,
restriction_feat = NULL, field=NULL,
p_ratio=20, interactive = FALSE, s_range = 150,
s_interaction = "medium", tolerance = 0.07,
crsys = "EPSG:27700")
#If `n_events` is a vector of values,
#retrieve the simulated data for the
#corresponding vector element by using
#`simulated_stpp[[enter-element-index-here]]`, e.g.,
#to retrieve the first dataframe, use
#simulated_stpp[[1]].

#The above example simulates point patterns on
#an unrestricted landscape. If \code{restriction_feat = landuse} and \code{field = "restrVal"},
then the simulation
#is run with the landuse features as restrictions
#on the landscape.
}
}
\references{
Davies, T.M. and Hazelton, M.L. (2010), Adaptive
kernel estimation of spatial relative risk,
Statistics in Medicine, 29(23) 2423-2437.
Terrell, G.R. (1990), The maximal smoothing principle
in density estimation, Journal of the
American Statistical Association, 85, 470-477.
}
