% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stp_learner.R
\name{stp_learner}
\alias{stp_learner}
\title{Learning the spatiotemporal properties of
a sample data}
\usage{
stp_learner(ppt, start_date = NULL, poly = NULL,
n_origin=50, p_ratio, gridSize = 150, s_range =  150,
tolerance = 0.07,
crsys = NULL, show.plot = FALSE)
}
\arguments{
\item{ppt}{A 3-column matrix or list containing
\code{x} - eastings, \code{y} - northing, and \code{t} - time of occurrence
(in the format: `yyyy-mm-dd').}

\item{start_date}{the start date of the temporal pattern.
The date should be in the format \code{"yyyy-mm-dd"}.
The temporal pattern will normally
cover 1-year period.}

\item{poly}{(An sf or S4 object)
a polygon shapefile defining the extent of the landscape}

\item{n_origin}{number of locations to serve as
origins for walkers. Default:\code{50}.}

\item{p_ratio}{(an integer) The smaller of the
two terms of a Pareto ratio.
For example, a value of \code{20}
implies a \code{20:80} Pareto ratio.}

\item{gridSize}{the size of square grid
to use for discretizing the space.
Default is: \code{150}.}

\item{s_range}{A value (in metres), not less than 150,
specifying the maximum range of spatial
interaction across the space. For example, for 150m,
the intervals of spatial interactions are created as
\code{(0, 50]}, \code{(50 - 100]}, and \code{(100-150]},
representing the "small", "medium", and "large",
spatial interaction ranges, respectively. If
\code{s_range} is set as \code{NULL}, simulation
focusses only on generating point pattern with
similar spatiotemporal patterns as the sample
dataset.}

\item{tolerance}{Pvalue to use for the extraction of
space-time interaction in the sample data. Default
value: \code{0.07}.}

\item{crsys}{(string) the EPSG code of the projection
system of the \code{ppt} coordinates. This only used if
\code{poly} argument is \code{NULL}.
See "http://spatialreference.org/" for the list of
EPSG codes for different regions of the world.
As an example, the EPSG code for the British National Grid
projection system is: \code{"EPSG:27700"}.}

\item{show.plot}{(TRUE or FALSE) Whether to show
some displays.}
}
\value{
an object (list) containing specific spatial
and temporal properties of a sample dataset.
}
\description{
Learns both the spatial and the temporal
properties of a real sample dataset.
}
\details{
Returns an object of the class \code{real_spo},
storing details of the spatiotemporal
properties of the sample data learnt.
}
\examples{
\dontrun{
#Goal: To learn the ST properties
#of a sample data, for the purpose of
#simulating the full dataset (see `psim_real`).
data(camden_crimes)
#subset 'theft' crime
theft <- camden_crimes[which(camden_crimes$type ==
"Theft"),1:3]
#specify the proportion of full data to use
sample_size <- 0.3
set.seed(1000)
dat_sample <- theft[sample(1:nrow(theft),
round((sample_size * nrow(theft)), digits=0),
replace=FALSE),]
#plot(dat_sample$x, dat_sample$y) #preview

stp_learner(dat_sample,
start_date = NULL, poly = NULL, n_origin=50,
p_ratio=20, gridSize = 150,
s_range =  150, tolerance = 0.07,
crsys = "EPSG:27700",
show.plot = FALSE)
}
}
\references{
Silverman, B.W., 2018. Density estimation
for statistics and data analysis. Routledge.
}
