% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.names}
\alias{is.names}
\title{Test for `names`}
\usage{
is.names(nm, x)
}
\arguments{
\item{nm}{character vector.}

\item{x}{object whose names are desired to be tested.}
}
\value{
TRUE for every element of `nm` that is a name of `x` and FALSE otherwise.
The structure is a logical vector with length = length(`nm`) and names = `nm`.
See details for special cases.
}
\description{
\code{is.names} returns whether elements of a character vector are names of an object.
}
\details{
If the object does not have any names, then the function will return `FALSE`
for each element `nm`.
}
\examples{
v <- setNames(object = letters, nm = LETTERS)
is.names(x = v, nm = c("A","a"))
data("mtcars")
is.names(x = mtcars, nm = c("MPG","mpg"))
}
