% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fixed.differences}
\alias{fixed.differences}
\title{Fixed Differences}
\usage{
fixed.differences(g, count.indels = T, consec.indels.as.one = T,
  bases = c("a", "c", "g", "t", "-"), num.cores = 1)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{count.indels}{logical. Count indels when evaluating sites for fixed differences?}

\item{consec.indels.as.one}{logical. If \code{count.indels} is TRUE, count consecutive indels as a a single indel?}

\item{bases}{a character vector of valid bases to consider.}

\item{num.cores}{number of CPU cores to use. Value is passed to \code{\link[parallel]{mclapply}}.}
}
\value{
a list with components:
\tabular{ll}{
  \code{sites} \tab list of sites with fixed differences for each pair of strata \cr
  \code{num.fixed} \tab data.frame of number of sites fixed between each pair of strata \cr
}
}
\description{
Summarize fixed base pair differences between strata.
}
\author{
Eric Archer <eric.archer@noaa.gov>
}

