/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.github.javacliparser.FloatOption;
import moa.evaluation.BasicClassificationPerformanceEvaluator;

public class FadingFactorClassificationPerformanceEvaluator
extends BasicClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Fading factor or exponential smoothing factor", 0.999);

    @Override
    protected BasicClassificationPerformanceEvaluator.Estimator newEstimator() {
        return new FadingFactorEstimator(this.alphaOption.getValue());
    }

    public class FadingFactorEstimator
    implements BasicClassificationPerformanceEvaluator.Estimator {
        protected double alpha;
        protected double estimation;
        protected double b;

        public FadingFactorEstimator(double a) {
            this.alpha = a;
            this.estimation = 0.0;
            this.b = 0.0;
        }

        @Override
        public void add(double value) {
            this.estimation = this.alpha * this.estimation + value;
            this.b = this.alpha * this.b + 1.0;
        }

        @Override
        public double estimation() {
            return this.b > 0.0 ? this.estimation / this.b : 0.0;
        }
    }
}

