/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.active;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import moa.core.StringUtils;
import moa.evaluation.preview.Preview;
import moa.gui.PreviewPanel;
import moa.gui.active.ALTaskTextViewerPanel;
import moa.tasks.FailedTaskReport;
import moa.tasks.ResultPreviewListener;
import moa.tasks.meta.ALMainTask;
import moa.tasks.meta.ALPartitionEvaluationTask;
import moa.tasks.meta.ALTaskThread;

public class ALPreviewPanel
extends JPanel
implements ResultPreviewListener {
    private static final long serialVersionUID = 1L;
    protected ALTaskThread previewedThread;
    protected JLabel previewLabel;
    protected JButton refreshButton;
    protected JLabel autoRefreshLabel;
    protected JComboBox<String> autoRefreshComboBox;
    protected ALTaskTextViewerPanel textViewerPanel = new ALTaskTextViewerPanel();
    protected Timer autoRefreshTimer;

    public ALPreviewPanel() {
        this.previewLabel = new JLabel("No preview available");
        this.refreshButton = new JButton("Refresh");
        this.autoRefreshLabel = new JLabel("Auto refresh: ");
        this.autoRefreshComboBox = new JComboBox<String>(PreviewPanel.autoFreqStrings);
        this.autoRefreshComboBox.setSelectedIndex(1);
        JPanel controlPanel = new JPanel();
        controlPanel.add(this.previewLabel);
        controlPanel.add(this.refreshButton);
        controlPanel.add(this.autoRefreshLabel);
        controlPanel.add(this.autoRefreshComboBox);
        this.setLayout(new BorderLayout());
        this.add((Component)controlPanel, "North");
        this.add((Component)this.textViewerPanel, "Center");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ALPreviewPanel.this.refresh();
            }
        });
        this.autoRefreshTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ALPreviewPanel.this.refresh();
            }
        });
        this.autoRefreshComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ALPreviewPanel.this.updateAutoRefreshTimer();
            }
        });
        this.setTaskThreadToPreview(null);
    }

    private void refresh() {
        if (this.previewedThread != null) {
            if (this.previewedThread.isComplete()) {
                this.setLatestPreview();
                this.disableRefresh();
            } else {
                this.previewedThread.getPreview(this);
            }
        }
    }

    public void setTaskThreadToPreview(ALTaskThread thread) {
        this.previewedThread = thread;
        this.setLatestPreview();
        if (thread == null) {
            this.disableRefresh();
        } else if (!thread.isComplete()) {
            this.enableRefresh();
        }
    }

    private void setLatestPreview() {
        if (this.previewedThread != null && this.previewedThread.failed()) {
            FailedTaskReport failedTaskReport = (FailedTaskReport)this.previewedThread.getFinalResult();
            this.textViewerPanel.setErrorText(failedTaskReport);
            this.textViewerPanel.setGraph(null, null);
        } else {
            Preview preview = null;
            if (this.previewedThread != null && this.previewedThread.isComplete()) {
                preview = (Preview)this.previewedThread.getFinalResult();
                this.previewLabel.setText("Final result");
                this.disableRefresh();
            } else if (this.previewedThread != null) {
                preview = (Preview)this.previewedThread.getLatestResultPreview();
                double grabTime = this.previewedThread.getLatestPreviewGrabTimeSeconds();
                String grabString = " (" + StringUtils.secondsToDHMSString(grabTime) + ")";
                if (preview == null) {
                    this.previewLabel.setText("No preview available" + grabString);
                } else {
                    this.previewLabel.setText("Preview" + grabString);
                }
            } else {
                this.previewLabel.setText("No preview available");
                preview = null;
            }
            this.textViewerPanel.setText(preview);
            this.textViewerPanel.setGraph(preview, this.getColorCodings(this.previewedThread));
        }
    }

    private Color[] getColorCodings(ALTaskThread thread) {
        if (thread == null) {
            return null;
        }
        ALMainTask task = (ALMainTask)thread.getTask();
        List<ALTaskThread> subtaskThreads = task.getSubtaskThreads();
        if (subtaskThreads.size() == 0) {
            return new Color[]{task.getColorCoding()};
        }
        if (task.getClass() == ALPartitionEvaluationTask.class) {
            return this.getColorCodings(subtaskThreads.get(0));
        }
        Color[] colors = new Color[subtaskThreads.size()];
        for (int i = 0; i < subtaskThreads.size(); ++i) {
            ALMainTask subtask = (ALMainTask)subtaskThreads.get(i).getTask();
            colors[i] = subtask.getColorCoding();
        }
        return colors;
    }

    private void updateAutoRefreshTimer() {
        int autoDelay = PreviewPanel.autoFreqTimeSecs[this.autoRefreshComboBox.getSelectedIndex()];
        if (autoDelay > 0) {
            if (this.autoRefreshTimer.isRunning()) {
                this.autoRefreshTimer.stop();
            }
            this.autoRefreshTimer.setDelay(autoDelay * 1000);
            this.autoRefreshTimer.start();
        } else {
            this.autoRefreshTimer.stop();
        }
    }

    private void disableRefresh() {
        this.refreshButton.setEnabled(false);
        this.autoRefreshLabel.setEnabled(false);
        this.autoRefreshComboBox.setEnabled(false);
        this.autoRefreshTimer.stop();
    }

    private void enableRefresh() {
        this.refreshButton.setEnabled(true);
        this.autoRefreshLabel.setEnabled(true);
        this.autoRefreshComboBox.setEnabled(true);
        this.updateAutoRefreshTimer();
    }

    @Override
    public void latestPreviewChanged() {
        this.setTaskThreadToPreview(this.previewedThread);
    }
}

