/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.splitcriteria;

import moa.classifiers.core.splitcriteria.VarianceReductionSplitCriterion;
import moa.classifiers.rules.core.splitcriteria.AMRulesSplitCriterion;

public class VRSplitCriterion
extends VarianceReductionSplitCriterion
implements AMRulesSplitCriterion {
    private static final long serialVersionUID = -1066043659710778883L;

    @Override
    public double[] computeBranchSplitMerits(double[][] postSplitDists) {
        double Ni;
        int i;
        double[] SDR = new double[postSplitDists.length];
        double N = 0.0;
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            N += Ni;
        }
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            SDR[i] = Ni / N * VRSplitCriterion.computeSD(postSplitDists[i]);
        }
        return SDR;
    }

    @Override
    public double getMeritOfSplit(double[] preSplitDist, double[][] postSplitDists) {
        double Ni;
        int i;
        double SDR = 0.0;
        double N = preSplitDist[0];
        int count = 0;
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            if (!(Ni >= 0.05 * N)) continue;
            ++count;
        }
        if (count == postSplitDists.length) {
            SDR = VRSplitCriterion.computeSD(preSplitDist);
            for (i = 0; i < postSplitDists.length; ++i) {
                Ni = postSplitDists[i][0];
                SDR -= Ni / N * VRSplitCriterion.computeSD(postSplitDists[i]);
            }
        }
        return SDR;
    }
}

