/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.core.Example;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.evaluation.MultiTargetPerformanceEvaluator;
import moa.evaluation.RegressionPerformanceEvaluator;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class MultiTargetWindowRegressionPerformanceEvaluator
extends AbstractOptionHandler
implements MultiTargetPerformanceEvaluator,
RegressionPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window", 1000);
    protected double TotalweightObserved = 0.0;
    protected Estimator weightObserved;
    protected Estimator squareError;
    protected Estimator averageError;
    protected int numClasses;
    protected int numberOutputs;

    @Override
    public void reset() {
        this.reset(this.numClasses);
    }

    public void reset(int numClasses) {
        this.numClasses = numClasses;
        this.weightObserved = new Estimator(this.widthOption.getValue());
        this.squareError = new Estimator(this.widthOption.getValue());
        this.averageError = new Estimator(this.widthOption.getValue());
        this.TotalweightObserved = 0.0;
    }

    @Override
    public void addResult(Example<Instance> example, double[] prediction) {
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.getTotalWeightObserved()), new Measurement("mean absolute error", this.getMeanError()), new Measurement("root mean squared error", this.getSquareError())};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved.total();
    }

    public double getMeanError() {
        return this.weightObserved.total() > 0.0 ? this.averageError.total() / (this.weightObserved.total() * (double)this.numberOutputs) : 0.0;
    }

    public double getSquareError() {
        return Math.sqrt(this.weightObserved.total() > 0.0 ? this.squareError.total() / (this.weightObserved.total() * (double)this.numberOutputs) : 0.0);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public void addResult(Example<Instance> testInst, Prediction prediction) {
        MultiLabelInstance inst = (MultiLabelInstance)testInst.getData();
        double weight = inst.weight();
        if (this.numberOutputs == 0) {
            this.numberOutputs = inst.numberOutputTargets();
        }
        if (weight > 0.0) {
            if (this.TotalweightObserved == 0.0) {
                this.reset(inst.dataset().numClasses());
            }
            this.TotalweightObserved += weight;
            this.weightObserved.add(weight);
            if (prediction != null) {
                for (int i = 0; i < this.numberOutputs; ++i) {
                    double error = inst.valueOutputAttribute(i) - prediction.getVote(i, 0);
                    this.squareError.add(error * error);
                    this.averageError.add(Math.abs(error));
                }
            }
        }
    }

    public class Estimator {
        protected double[] window;
        protected int posWindow;
        protected int lenWindow;
        protected int SizeWindow;
        protected double sum;

        public Estimator(int sizeWindow) {
            this.window = new double[sizeWindow];
            this.SizeWindow = sizeWindow;
            this.posWindow = 0;
        }

        public void add(double value) {
            this.sum -= this.window[this.posWindow];
            this.sum += value;
            this.window[this.posWindow] = value;
            ++this.posWindow;
            if (this.posWindow == this.SizeWindow) {
                this.posWindow = 0;
            }
        }

        public double total() {
            return this.sum;
        }
    }
}

