/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import moa.gui.experimentertab.Algorithm;
import moa.gui.experimentertab.Measure;
import moa.gui.experimentertab.Stream;
import moa.gui.experimentertab.SummaryTable;

public class Summary {
    public List<Stream> streams = new ArrayList<Stream>();
    public String path = "";
    public SummaryTable[] summary;

    public Summary(List<Stream> streams, String path) {
        this.streams = streams;
        this.path = path;
    }

    public void generateLatex(String path) {
        int i;
        String output = "";
        output = output + "\\documentclass{article}\n";
        output = output + "\\usepackage{multirow}\n\\usepackage{booktabs}\n\\begin{document}\n\\begin{table}[htbp]\n\\caption{Add caption}";
        output = output + "\\begin{tabular}";
        output = output + "{";
        for (i = 0; i < this.streams.size() + 4; ++i) {
            output = output + "r";
        }
        output = output + "}\n\\toprule\nAlgorithm & \\multicolumn{2}{r}{Measure}";
        for (i = 0; i < this.streams.size(); ++i) {
            output = output + "& " + this.streams.get(i).getName();
        }
        output = output + "& AVG\\\\\n\\midrule\n";
        int algorithmSize = this.streams.get((int)0).algorithm.size();
        String name = "";
        for (int i2 = 0; i2 < algorithmSize; ++i2) {
            List<Algorithm> alg = this.streams.get((int)0).algorithm;
            output = output + "\\multirow{" + alg.get((int)i2).measureStdSize + "}[" + 6 + "]{*}{" + alg.get((int)i2).name + "}";
            List<Measure>[] measures = alg.get(i2).getMeasuresPerData(this.streams);
            double sum = 0.0;
            boolean isType = true;
            for (int cont = 0; cont != this.streams.get((int)0).algorithm.get((int)i2).measures.size(); ++cont) {
                sum = 0.0;
                name = measures[0].get(cont).getName();
                if (measures[0].get(cont).isType()) {
                    output = output + "&\\multirow{2}[4]{*}{" + name + "} & mean";
                } else {
                    output = output + " & " + name;
                    output = output + "& Last value";
                }
                for (int j = 0; j < measures.length; ++j) {
                    if (measures[j].get(cont).isType()) {
                        output = output + " & " + Algorithm.format(measures[j].get(cont).getValue());
                        sum += measures[j].get(cont).getValue().doubleValue();
                        isType = true;
                        continue;
                    }
                    output = output + " & " + Algorithm.format1(measures[j].get(cont).getValue());
                    isType = false;
                }
                if (isType) {
                    double size = this.streams.size();
                    output = output + "& " + Algorithm.format(sum / size);
                    output = output + "\\\\\n";
                    output = output + " & & std";
                    for (int j = 0; j < measures.length; ++j) {
                        output = output + " & " + Algorithm.format(measures[j].get(cont).getStd());
                    }
                    output = output + " & -";
                } else {
                    output = output + " & -";
                }
                output = output + "\\\\\n";
            }
        }
        output = output + "\\bottomrule\n\\end{tabular}%\n\\label{tab:addlabel}%\n\\end{table}%\n\\end{document}";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path + "summary.tex"));
            out.write(output);
            out.close();
        }
        catch (IOException e) {
            System.out.println(" Error saving summary.tex");
        }
    }

    public void invertedSumariesPerMeasure(String path) {
        int algorithmSize = this.streams.get((int)0).algorithm.size();
        int streamSize = this.streams.size();
        int measureSize = this.streams.get((int)0).algorithm.get((int)0).measures.size();
        for (int cont = 0; cont != measureSize; ++cont) {
            int i;
            String output = "";
            output = output + "\\documentclass{article}\n";
            output = output + "\\usepackage{multirow}\n\\usepackage{booktabs}\n\\begin{document}\n\\begin{table}[htbp]\n\\caption{Add caption}";
            output = output + "\\begin{tabular}";
            output = output + "{";
            for (i = 0; i < algorithmSize + 1; ++i) {
                output = output + "r";
            }
            output = output + "}\n\\toprule\nAlgorithm";
            for (i = 0; i < algorithmSize; ++i) {
                output = output + "& " + this.streams.get((int)0).algorithm.get((int)i).name;
            }
            output = output + "\\\\";
            output = output + "\n\\midrule\n";
            for (i = 0; i < streamSize; ++i) {
                List<Algorithm> alg = this.streams.get((int)i).algorithm;
                output = output + this.streams.get((int)i).name;
                for (int j = 0; j < algorithmSize; ++j) {
                    output = alg.get((int)j).measures.get(cont).isType() ? output + "&" + Algorithm.format(alg.get((int)j).measures.get(cont).getValue()) + "$\\,\\pm$" + Algorithm.format(alg.get((int)j).measures.get(cont).getStd()) : output + "&" + Algorithm.format1(alg.get((int)j).measures.get(cont).getValue());
                }
                output = output + "\\\\\n";
            }
            output = output + "\\bottomrule\n\\end{tabular}%\n\\label{tab:addlabel}%\n\\end{table}%\n\\end{document}";
            String name = this.streams.get((int)0).algorithm.get((int)0).measures.get(cont).getName();
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(path + name + ".tex"));
                out.write(output);
                out.close();
                continue;
            }
            catch (IOException e) {
                System.out.println("Error saving " + name + ".tex");
            }
        }
    }

    public SummaryTable[] showSummary() {
        int algorithmSize = this.streams.get((int)0).algorithm.size();
        int streamSize = this.streams.size();
        int measureSize = this.streams.get((int)0).algorithm.get((int)0).measures.size();
        this.summary = new SummaryTable[measureSize];
        for (int cont = 0; cont != measureSize; ++cont) {
            int i;
            this.summary[cont] = new SummaryTable();
            this.summary[cont].measureName = this.streams.get((int)0).algorithm.get((int)0).measures.get(cont).getName();
            this.summary[cont].algNames = new String[algorithmSize + 1];
            this.summary[cont].algNames[0] = "Algorithm";
            this.summary[cont].value = new Object[streamSize][algorithmSize + 1];
            for (i = 0; i < algorithmSize; ++i) {
                this.summary[cont].algNames[i + 1] = this.streams.get((int)0).algorithm.get((int)i).name;
            }
            for (i = 0; i < streamSize; ++i) {
                List<Algorithm> alg = this.streams.get((int)i).algorithm;
                this.summary[cont].value[i][0] = this.streams.get((int)i).name;
                for (int j = 0; j < algorithmSize; ++j) {
                    this.summary[cont].value[i][j + 1] = alg.get((int)j).measures.get(cont).isType() ? Algorithm.format(alg.get((int)j).measures.get(cont).getValue()) + "\u00b1" + Algorithm.format(alg.get((int)j).measures.get(cont).getStd()) : Algorithm.format1(alg.get((int)j).measures.get(cont).getValue());
                }
            }
        }
        return this.summary;
    }

    public void generateHTML(String path) {
        String output = "";
        output = output + "<TABLE BORDER=1 WIDTH=\"100%\" ALIGN=CENTER>\n";
        output = output + "<CAPTION> Experiment";
        output = output + "<TR> <TD>Algorithm <TD COLSPAN = 2>Measure";
        for (int i = 0; i < this.streams.size(); ++i) {
            output = output + "<TD>" + this.streams.get(i).getName();
        }
        output = output + "<TD>AVG";
        int algorithmSize = this.streams.get((int)0).algorithm.size();
        String name = "";
        for (int i = 0; i < algorithmSize; ++i) {
            List<Algorithm> alg = this.streams.get((int)0).algorithm;
            output = output + "<TR><TD ROWSPAN = " + alg.get((int)i).measureStdSize + ">" + alg.get((int)i).name;
            List<Measure>[] measures = alg.get(i).getMeasuresPerData(this.streams);
            double sum = 0.0;
            boolean isType = true;
            for (int cont = 0; cont != this.streams.get((int)0).algorithm.get((int)i).measures.size(); ++cont) {
                sum = 0.0;
                name = measures[0].get(cont).getName();
                if (measures[0].get(cont).isType()) {
                    output = output + "<TD ROWSPAN = 2>" + name;
                    output = output + "<TD>mean";
                } else {
                    output = output + "<TD>" + name;
                    output = output + "<TD>Last value";
                }
                for (int j = 0; j < measures.length; ++j) {
                    if (measures[j].get(cont).isType()) {
                        output = output + "<TD>" + Algorithm.format(measures[j].get(cont).getValue());
                        sum += measures[j].get(cont).getValue().doubleValue();
                        isType = true;
                        continue;
                    }
                    output = output + "<TD>" + Algorithm.format1(measures[j].get(cont).getValue());
                    isType = false;
                }
                if (isType) {
                    double size = this.streams.size();
                    output = output + "<TD>" + Algorithm.format(sum / size);
                    output = output + "<TR>";
                    output = output + "<TD>std";
                    for (int j = 0; j < measures.length; ++j) {
                        output = output + "<TD>" + Algorithm.format(measures[j].get(cont).getStd());
                    }
                    output = output + "<TD>-";
                } else {
                    output = output + "<TD>-";
                }
                output = output + "<TR>";
            }
        }
        output = output + "</TABLE>";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path + "summary.html"));
            out.write(output);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error saving summary.html");
        }
    }

    public void computeWinsTiesLossesLatex(String path) {
        int i;
        List<Algorithm> alg = this.streams.get((int)0).algorithm;
        int algorithmSize = this.streams.get((int)0).algorithm.size();
        String output = "";
        output = output + "\\documentclass{article}\n";
        output = output + "\\usepackage[latin9]{inputenc}\n\\usepackage{array}\n\\usepackage{rotfloat}\n\\usepackage{multirow}\n\n\\makeatletter\n\\providecommand{\\tabularnewline}{\\\\}\n\\usepackage{multirow}\n\\usepackage{booktabs}\n\\makeatother\n\n\\begin{document}\n\\begin{sidewaystable}\n\\centering \\caption{Add caption}\n\\begin{tabular}";
        output = output + "{|r|r|";
        for (i = 2; i <= algorithmSize * 3; ++i) {
            output = i <= algorithmSize ? output + "r" : (i == algorithmSize * 3 ? output + "|" : output + "|r");
        }
        output = output + "}\n\\hline\n";
        output = output + "\\multirow{2}{*}{Algorithm } & \\multirow{2}{*}{PM} &";
        output = output + "\\multicolumn{3}{r|}{" + alg.get((int)1).name + "}";
        for (i = 2; i < algorithmSize; ++i) {
            output = output + " & \\multicolumn{3}{r|}{" + alg.get((int)i).name + "}";
        }
        output = output + "& \\multirow{2}{*}{AVG}\\tabularnewline\n";
        output = output + "\\cline{3-" + (algorithmSize * 3 - 1) + "}\n";
        output = output + " & & ";
        output = output + "\\multicolumn{1}{r|}{W} & \\multicolumn{1}{r|}{L} & \\multicolumn{1}{r|}{T} & ";
        for (i = 2; i < algorithmSize; ++i) {
            output = output + "\\multicolumn{1}{r|}{W} & \\multicolumn{1}{r|}{L} & \\multicolumn{1}{r|}{T} & ";
        }
        output = output + "\\tabularnewline\n\\hline\n";
        int range = 3;
        int measuresSize = this.streams.get((int)0).algorithm.get((int)0).measures.size();
        for (int i2 = 0; i2 < algorithmSize; ++i2) {
            output = output + "\\multirow{" + alg.get((int)i2).measures.size() + "}{*}{" + alg.get((int)i2).name + "}";
            List<Measure>[] measureRow = alg.get(i2).getMeasuresPerData(this.streams);
            for (int cont = 0; cont != measuresSize; ++cont) {
                String name = alg.get((int)i2).measures.get(cont).getName();
                output = output + " & " + name;
                double sum = 0.0;
                for (int j = 1; j < algorithmSize; ++j) {
                    List<Measure>[] measureCol = alg.get(j).getMeasuresPerData(this.streams);
                    int win = 0;
                    int losses = 0;
                    int ties = 0;
                    for (int k = 0; k < measureCol.length; ++k) {
                        double alg1 = measureRow[k].get(cont).getValue();
                        double alg2 = measureCol[k].get(cont).getValue();
                        if (j == 1) {
                            sum += measureRow[k].get(cont).getValue().doubleValue();
                        }
                        if (measureRow[k].get(cont).isType()) {
                            if (Algorithm.Round(alg1) > Algorithm.Round(alg2)) {
                                ++win;
                                continue;
                            }
                            if (Algorithm.Round(alg1) < Algorithm.Round(alg2)) {
                                ++losses;
                                continue;
                            }
                            ++ties;
                            continue;
                        }
                        if (alg1 < alg2) {
                            ++win;
                            continue;
                        }
                        if (alg1 > alg2) {
                            ++losses;
                            continue;
                        }
                        ++ties;
                    }
                    if (i2 < j) {
                        output = output + " & \\multicolumn{1}{r|}{" + win + "}";
                        output = output + " & \\multicolumn{1}{r|}{" + losses + "}";
                        output = output + " & \\multicolumn{1}{r|}{" + ties + "}";
                        continue;
                    }
                    if (i2 == j) {
                        output = output + " & \\multicolumn{1}{r}{}";
                        output = output + " & \\multicolumn{1}{r}{}";
                        output = output + " & \\multicolumn{1}{r|}{}";
                        continue;
                    }
                    output = output + " & \\multicolumn{1}{r}{}";
                    output = output + " & \\multicolumn{1}{r}{}";
                    output = output + " & \\multicolumn{1}{r}{}";
                }
                output = output + " & " + Algorithm.format(sum /= (double)measureRow.length);
                output = cont < measuresSize - 1 ? output + "\\tabularnewline\n \\cline{2-2} \\cline{" + range + "-" + algorithmSize * 3 + "}\n" : (i2 != algorithmSize - 1 ? output + "\\tabularnewline\n \\cline{1-2} \\cline{" + range + "-" + algorithmSize * 3 + "}\n" : output + "\\tabularnewline\n \\cline{1-" + algorithmSize * 3 + "}\n");
            }
            range += 3;
        }
        output = output + "\\end{tabular}\\label{tab:addlabel}\n\\end{sidewaystable}\n\n\\end{document}";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path + "summary.win.ties.losses.tex"));
            out.write(output);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error saving summary.win.ties.losses.tex");
        }
    }

    public void generateCSV() {
        int algorithmSize = this.streams.get((int)0).algorithm.size();
        int streamSize = this.streams.size();
        int measureSize = this.streams.get((int)0).algorithm.get((int)0).measures.size();
        for (int cont = 0; cont != measureSize; ++cont) {
            int i;
            String output = "";
            output = output + "Algorithm,";
            output = output + this.streams.get((int)0).algorithm.get((int)0).name;
            for (i = 1; i < algorithmSize; ++i) {
                output = output + "," + this.streams.get((int)0).algorithm.get((int)i).name;
            }
            output = output + "\n";
            for (i = 0; i < streamSize; ++i) {
                List<Algorithm> alg = this.streams.get((int)i).algorithm;
                output = output + this.streams.get((int)i).name;
                for (int j = 0; j < algorithmSize; ++j) {
                    output = output + "," + alg.get((int)j).measures.get(cont).getValue();
                }
                output = output + "\n";
            }
            String name = this.streams.get((int)0).algorithm.get((int)0).measures.get(cont).getName();
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.path + name + ".csv"));
                out.write(output);
                out.close();
                continue;
            }
            catch (IOException e) {
                System.out.println(name + ".csv");
            }
        }
    }

    public void computeWinsTiesLossesHTML(String path) {
        int i;
        List<Algorithm> alg = this.streams.get((int)0).algorithm;
        int algorithmSize = this.streams.get((int)0).algorithm.size();
        String tablaSalida = "";
        tablaSalida = tablaSalida + "<TABLE BORDER=1 WIDTH=\"100%\" ALIGN=CENTER>\n";
        tablaSalida = tablaSalida + "<CAPTION> Experiment";
        tablaSalida = tablaSalida + "<TR> <TD ROWSPAN = 2>Algorithm <TD TD ROWSPAN = 2>PM";
        for (i = 1; i < algorithmSize; ++i) {
            tablaSalida = tablaSalida + "<TD COLSPAN = 3>" + alg.get((int)i).name;
        }
        tablaSalida = tablaSalida + "<TD>AVG";
        tablaSalida = tablaSalida + "<TR>";
        for (i = 1; i < algorithmSize; ++i) {
            tablaSalida = tablaSalida + "<TD>Wins<TD>Losses<TD>Ties";
        }
        for (i = 0; i < algorithmSize; ++i) {
            tablaSalida = tablaSalida + "<TR><TD ROWSPAN = " + alg.get((int)i).measures.size() + ">" + alg.get((int)i).name;
            List<Measure>[] measureRow = alg.get(i).getMeasuresPerData(this.streams);
            for (int cont = 0; cont != this.streams.get((int)0).algorithm.get((int)i).measures.size(); ++cont) {
                String name = alg.get((int)i).measures.get(cont).getName();
                tablaSalida = tablaSalida + "<TD>" + name;
                double sum = 0.0;
                for (int j = 1; j < algorithmSize; ++j) {
                    List<Measure>[] measureCol = alg.get(j).getMeasuresPerData(this.streams);
                    int win = 0;
                    int losses = 0;
                    int ties = 0;
                    for (int k = 0; k < measureCol.length; ++k) {
                        double alg1 = measureRow[k].get(cont).getValue();
                        double alg2 = measureCol[k].get(cont).getValue();
                        if (j == 1) {
                            sum += measureRow[k].get(cont).getValue().doubleValue();
                        }
                        if (measureRow[k].get(cont).isType()) {
                            if (Algorithm.Round(alg1) > Algorithm.Round(alg2)) {
                                ++win;
                                continue;
                            }
                            if (Algorithm.Round(alg1) < Algorithm.Round(alg2)) {
                                ++losses;
                                continue;
                            }
                            ++ties;
                            continue;
                        }
                        if (alg1 < alg2) {
                            ++win;
                            continue;
                        }
                        if (alg1 > alg2) {
                            ++losses;
                            continue;
                        }
                        ++ties;
                    }
                    if (i < j) {
                        tablaSalida = tablaSalida + "<TD>" + win;
                        tablaSalida = tablaSalida + "<TD>" + losses;
                        tablaSalida = tablaSalida + "<TD>" + ties;
                        continue;
                    }
                    tablaSalida = tablaSalida + "<TD> ";
                    tablaSalida = tablaSalida + "<TD> ";
                    tablaSalida = tablaSalida + "<TD> ";
                }
                tablaSalida = tablaSalida + "<TD>" + Algorithm.format(sum /= (double)measureRow.length);
                tablaSalida = tablaSalida + "<TR>";
            }
        }
        tablaSalida = tablaSalida + "</TABLE>";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path + "summary.win.ties.losses.html"));
            out.write(tablaSalida);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error saving summary.win.ties.losses.html");
        }
    }
}

