% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{set_all_stremr_options}
\alias{set_all_stremr_options}
\title{Setting \code{stremr} Options}
\usage{
set_all_stremr_options(fit.package = c("speedglm", "glm", "h2o"),
  fit.algorithm = c("glm", "gbm", "randomForest", "deeplearning",
  "SuperLearner"), bin.method = c("equal.mass", "equal.len", "dhist"),
  nbins = 10, maxncats = 20, maxNperBin = 500,
  lower_bound_zero_Q = TRUE, skip_update_zero_Q = TRUE)
}
\arguments{
\item{fit.package}{Specify the default package for performing model fitting: c("speedglm", "glm", "h2o")}

\item{fit.algorithm}{Specify the default fitting algorithm: c("glm", "gbm", "randomForest", "SuperLearner")}

\item{bin.method}{The method for choosing bins when discretizing and fitting the conditional continuous summary
exposure variable \code{sA}. The default method is \code{"equal.len"}, which partitions the range of \code{sA}
into equal length \code{nbins} intervals. Method \code{"equal.mass"} results in a data-adaptive selection of the bins
based on equal mass (equal number of observations), i.e., each bin is defined so that it contains an approximately
the same number of observations across all bins. The maximum number of observations in each bin is controlled
by parameter \code{maxNperBin}. Method \code{"dhist"} uses a mix of the above two approaches,
see Denby and Mallows "Variations on the Histogram" (2009) for more detail.}

\item{nbins}{Set the default number of bins when discretizing a continous outcome variable under setting
\code{bin.method = "equal.len"}.
If left as \code{NA} the total number of equal intervals (bins) is determined by the nearest integer of
\code{nobs}/\code{maxNperBin}, where \code{nobs} is the total number of observations in the input data.}

\item{maxncats}{Max number of unique categories a categorical variable \code{sA[j]} can have.
If \code{sA[j]} has more it is automatically considered continuous.}

\item{maxNperBin}{Max number of observations per 1 bin for a continuous outcome (applies directly when
\code{bin.method="equal.mass"} and indirectly when \code{bin.method="equal.len"}, but \code{nbins = NA}).}

\item{lower_bound_zero_Q}{Set to \code{TRUE} to bound the observation-specific Qs during the TMLE update step away from zero (with minimum value set at 10^-4).
Can help numerically stabilize the TMLE intercept estimates in some small-sample cases. Has no effect when \code{TMLE} = \code{FALSE}.}

\item{skip_update_zero_Q}{Set to \code{FALSE} to perform TMLE update with glm even when all of the Q's are zero.
When set to \code{TRUE} the TMLE update step is skipped if the predicted Q's are either all 0 or near 0, with TMLE intercept being set to 0.}
}
\value{
Invisibly returns a list with old option settings.
}
\description{
Options that control \code{stremr} package.
\strong{Will reset all unspecified options (omitted arguments) to their default values}.
The preferred way to set options for \code{stremr} is to use \code{\link{stremrOptions}}, which allows specifying individual options without having to reset all other options.
To reset all options to their defaults simply run \code{set_all_stremr_options()} without any parameters/arguments.
}
\seealso{
\code{\link{stremrOptions}}, \code{\link{print_stremr_opts}}
}

