% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{str_detect_all}
\alias{str_detect_all}
\alias{str_detect_any}
\title{Detect any or all patterns.}
\usage{
str_detect_all(string, pattern, negate = FALSE)

str_detect_any(string, pattern, negate = FALSE)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{A character vector. The patterns to look for. Default is
\code{stringi}-style regular expression. \code{\link[stringr:modifiers]{stringr::coll()}} and
\code{\link[stringr:modifiers]{stringr::fixed()}} are also permissible.}

\item{negate}{A flag. If \code{TRUE}, inverts the result.}
}
\value{
A character vector.
}
\description{
Vectorized over \code{pattern}.
}
\examples{
str_detect_all("quick brown fox", c("x", "y", "z"))
str_detect_all(c(".", "-"), ".")
str_detect_all(c(".", "-"), coll("."))
str_detect_all(c(".", "-"), coll("."), negate = TRUE)
str_detect_all(c(".", "-"), c(".", ":"))
str_detect_all(c(".", "-"), coll(c(".", ":")))

str_detect_any("quick brown fox", c("x", "y", "z"))
str_detect_any(c(".", "-"), ".")
str_detect_any(c(".", "-"), coll("."))
str_detect_any(c(".", "-"), coll("."), negate = TRUE)
str_detect_any(c(".", "-"), c(".", ":"))
str_detect_any(c(".", "-"), coll(c(".", ":")))

}
