% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strucUtils.R
\name{strucUtils}
\alias{check2lvl}
\alias{makeSpacings}
\alias{make_2level_with_center}
\alias{strucUtils}
\title{Utility Functions for stripless}
\usage{
check2lvl(d, sep = ".")

make_2level_with_center(lvls, sep = ".")

makeSpacings(spacings, levelLength)
}
\arguments{
\item{d}{Condition list from strucParseFormula to be checked to see if it
represents a 2 level design with center point.}

\item{sep}{sep argument for \code{paste()}.}

\item{lvls}{A list of length 3 character vectors that are the level names of
factors in a design to be checked.}

\item{spacings}{An integer vector}

\item{levelLength}{An integer vector giving the number of levels per factor
at each level of the plotting hierarchy}
}
\description{
Unexported functions not intended to be directly called by users.
}
\details{
\strong{Brief function descriptions:}
\describe{
 \item{check2lvl}{Checks for a 2 level design with center point}
 \item{make_2level_with_center}{Makes a 2 level design with center point to
  compare to a fraction of a \eqn{3^n} design}
  \item{makeSpacings}{Constructs a vector of spacings values for the "between"
  argument of \code{\link[lattice]{xyplot}}}
  }
}

