% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colNames.r
\name{colNames}
\alias{colNames}
\title{Column Names}
\usage{
colNames(data, slim = TRUE, concatenate = NULL, numbered = TRUE,
  debug = FALSE)
}
\arguments{
\item{data}{data.frame.}

\item{slim}{logical, TRUE returns column names occurring once,
FALSE returns column names occurring multiple times.}

\item{concatenate}{string, if not NULL returns a single string with column
names concatenated by the provided string instead of a vector.}

\item{numbered}{logical indicating if repeated column names must have a number suffix.}

\item{debug}{logical indicating printing debug information.}
}
\value{
character, vector or string.
}
\description{
Internal helper function.
}
\details{
Takes a data frame as input and return either column names
occurring once or multiple times. Matching is done by the 'base name'
(the substring to the left of the last period, if any). The return type
is a string vector by default, or a single string of column names separated
by a string 'concatenate' (see 'collapse' in \code{paste} for details).
There is an option to limit multiple names to those with a number suffix.
}
