% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCopies.r
\name{calculateCopies}
\alias{calculateCopies}
\title{Calculate Allele Copies}
\usage{
calculateCopies(data, observed = FALSE, copies = TRUE,
  heterozygous = FALSE, debug = FALSE)
}
\arguments{
\item{data}{Data frame containing at least columns 'Sample.Name', 'Marker,
and 'Allele*'.}

\item{observed}{logical indicating if a column 'Observed' should be
used to count the number of unique alleles.}

\item{copies}{logical indicating if a column 'Copies' should be used to
indicate the number of allele copies with 1 for heterozygotes and 2 for
homozygotes.}

\item{heterozygous}{logical indicating if a column 'Heterozygous' should be
used to indicate heterozygotes with 1 and homozygotes with 0.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame the original data frame with optional columns 'Observed',
'Copies', and 'Heterozygous'.
}
\description{
Calculates the number of alleles in each marker.
}
\details{
Calculates the number of unique values in the 'Allele*' columns
for each marker, the number of allele copies, or indicate heterozygous loci.
Observed - number of unique alleles.
Copies - number of allele copies, '1' for heterozygotes and '2' for homozygotes.
Heterozygous - '1' for heterozygous and '0' for homozygous loci.
NB! The 'copies' and 'heterozygous' option are intended for known complete
profiles, while 'observed' can be used for any samples to count the number
of peaks. Sample names must be unique. The result is per marker but repeated
for each row of that marker. Data in 'fat' format is auto slimmed.
}
