% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.r
\name{trim}
\alias{trim}
\title{Trim Data}
\usage{
trim(data, samples = NULL, columns = NULL, word = FALSE,
  ignore.case = TRUE, invert.s = FALSE, invert.c = FALSE,
  rm.na.col = TRUE, rm.empty.col = TRUE, missing = NA,
  debug = FALSE)
}
\arguments{
\item{data}{data.frame with genotype data.}

\item{samples}{string giving sample names separated by pipe (|).}

\item{columns}{string giving column names separated by pipe (|).}

\item{word}{logical indicating if a word boundary should be added to 
\code{samples} and \code{columns}.}

\item{ignore.case}{logical, TRUE ignore case in sample names.}

\item{invert.s}{logical, TRUE to remove matching samples from 'data',
FALSE to remove samples NOT matching (i.e. keep matching samples).}

\item{invert.c}{logical, TRUE to remove matching columns from 'data',
FALSE to remove columns NOT matching (i.e. keep matching columns).
while TRUE will remove columns NOT given.}

\item{rm.na.col}{logical, TRUE columns with only NA are removed from 'data'
while FALSE will preserve the columns.}

\item{rm.empty.col}{logical, TRUE columns with no values are removed from 'data'
while FALSE will preserve the columns.}

\item{missing}{value to replace missing values with.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with extracted result.
}
\description{
Extract data from a dataset.
}
\details{
Simplifies extraction of specific data from a larger dataset.
Look for samples in column named 'Sample.Name', 'Sample.File.Name', or
the first column containing the string 'Sample' in mentioned order
(not case sensitive). Remove unwanted columns.
}
