% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topicSemanticCoherence.R
\name{topicSemanticCoherence}
\alias{topicSemanticCoherence}
\title{Semantic Coherence}
\usage{
topicSemanticCoherence(object, corpus, M = 10)
}
\arguments{
\item{object}{Model output from sts}

\item{corpus}{The document term matrix to be modeled in a sparse term count matrix with one row
per document and one column per term. The object must be a list of with each element 
corresponding to a document. Each document is represented
as an integer matrix with two rows, and columns equal to the number of unique
vocabulary words in the document.  The first row contains the 1-indexed
vocabulary entry and the second row contains the number of times that term
appears. This is the same format in the \code{\link[stm]{stm}} package.}

\item{M}{the number of top words to consider per topic}
}
\value{
a numeric vector containing semantic coherence for each topic
}
\description{
Calculates semantic coherence for an STS model.
}
\examples{
\donttest{
#An example using the Gadarian data from the stm package.  From Raw text to 
# fitted model using textProcessor() which leverages the tm Package
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
out$meta$noTreatment <- ifelse(out$meta$treatment == 1, -1, 1)
## low max iteration number just for testing
sts_estimate <- sts(~ treatment*pid_rep, ~ noTreatment, out, K = 3, maxIter = 2, verbose = FALSE)
topicSemanticCoherence(sts_estimate, out)
}
}
