% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules-line-break.R
\name{set_line_break_if_call_is_multi_line}
\alias{set_line_break_if_call_is_multi_line}
\alias{set_line_break_after_opening_if_call_is_multi_line}
\alias{set_line_break_before_closing_call}
\alias{remove_line_break_in_empty_fun_call}
\title{Set line break for multi-line function calls}
\usage{
set_line_break_after_opening_if_call_is_multi_line(pd,
  except_token_after = NULL, except_text_before = NULL)

set_line_break_before_closing_call(pd, except_token_before)

remove_line_break_in_empty_fun_call(pd)
}
\arguments{
\item{pd}{A parse table.}

\item{except_token_after}{A character vector with tokens after "'('" that do
not cause a line break after "'('".}

\item{except_text_before}{A character vector with text before "'('" that do
not cause a line break after "'('".}

\item{except_token_before}{A character vector with text before "')'" that do
not cause a line break before "')'".}
}
\description{
Set line break for multi-line function calls
}
\section{Functions}{
\itemize{
\item \code{set_line_break_after_opening_if_call_is_multi_line}: Sets line break after
opening parenthesis.

\item \code{set_line_break_before_closing_call}: Sets line break before
closing parenthesis.
}}

\keyword{internal}
