% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-files.R
\name{dir_without_.}
\alias{dir_without_.}
\title{\code{dir()}, but without dot-prefix and different defaults}
\usage{
dir_without_.(path, recursive = TRUE, ...)
}
\arguments{
\item{path}{A path.}

\item{...}{Passed to \code{\link[base:list.files]{base::dir()}}.}
}
\description{
When using \code{dir()}, you can set \code{full.names = FALSE}, but then you can only
pass a character vector of length one as \code{path} to not loose the information
about where the files are. This function solves that case. It's needed when
one wants to standardize paths to use set operations on them, i.e. when the
user supplied input does not have a dot prefix. See 'Examples'.
}
\details{
For different defaults, see \code{dir_without_._one}.
}
\examples{
setdiff("./file.R", "file.R") # you want to standardize first.
}
\seealso{
set_and_assert_arg_paths
}
\keyword{internal}
