% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CTTsub.RegOnTotSub.R
\name{CTTsub.RegOnTotSub}
\alias{CTTsub.RegOnTotSub}
\title{This function Computes subscores based on both the observed subscore and the observed total in classical test theory (CTT)
score}
\usage{
CTTsub.RegOnTotSub(test.data)
}
\arguments{
\item{test.data}{A list that contains datasets of all subtests and the whole test,
which can be obtained using function 'data.prep'.}
}
\value{
A list of objects that include both test information and subscores. \cr
        (1) "subscore.information" - It contains test information of both subtests
                                     and the total test, such as mean of subscores and total score, reliability, and PRMSE.\cr
        (2) "subscore.original" - It contains original subscores and total score. \cr
        (3) "subscore.RegOnTotSub" - It contains subscores that are estimated based on both the observed subscore and the
                                     observed total score.
}
\description{
This function computes CTT subscores based on both the observed subscore and the observed total
score, using the method introduced in Haberman (2008), Haberman et al. (2009), and Sinharay (2010), which return:\cr
	(1) Original Observed subscore; \cr
	(2) The true subscore is estimated based on
	    both the observed subscore and the observed  total score.\cr
}
\examples{
CTTsub.RegOnSub(test.data)
}

