% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_hazard.R
\name{extract_hazard}
\alias{extract_hazard}
\title{Extract (inverse) cumulative baseline hazard from Cox PH model}
\usage{
extract_hazard(coxphmod)
}
\arguments{
\item{coxphmod}{A call to \code{\link[survival:coxph]{coxph()}}.}
}
\value{
A list containing:
\itemize{
\item \code{cbaseh}: A function which returns the cumulative baseline hazard
at specified time;
\item \code{inv_cbaseh}: A function which returns the inverse cumulative
baseline hazard at specified time.
\item \code{max_time}: maximal time at which \code{cbaseh} is known;
\item \code{max_haz}: value of maximal hazard (at maximum time).
}
}
\description{
Extracts a function which returns the (inverse) cumulative
baseline hazard from a \code{\link[survival:coxph]{coxph()}} call.
}
\examples{
require(survival)
exprfit <- as.formula("Surv(survtime, censorid) ~ age + sex + BMI")
tcoxmod <- coxph(exprfit, data= surgerydat)
tcox_hazard_fcts <- extract_hazard(tcoxmod)


}
\seealso{
\code{\link[survival:coxph]{coxph}}
}
\author{
Daniel Gomon
}
