% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descr.R
\name{descr}
\alias{descr}
\title{Univariate Statistics for Numerical Data}
\usage{
descr(x, stats = "all", na.rm = TRUE, round.digits = 2,
  transpose = FALSE, style = "simple", plain.ascii = TRUE,
  justify = "right", omit.headings = FALSE, use.labels = FALSE,
  display.labels = TRUE, weights = NA, rescale.weights = FALSE, ...)
}
\arguments{
\item{x}{A numerical vector or a data frame.}

\item{stats}{Which stats to produce. Either \dQuote{all} (default), or a
selection of : \dQuote{mean}, \dQuote{sd}, \dQuote{min}, \dQuote{med}, \dQuote{max},
\dQuote{mad}, \dQuote{iqr}, \dQuote{cv}, \dQuote{skewness}, \dQuote{se.skewness},
\dQuote{kurtosis}, \dQuote{n.valid}, and \dQuote{pct.valid}.}

\item{na.rm}{Argument to be passed to statistical functions. Defaults to
\code{TRUE}.}

\item{round.digits}{Number of significant digits to display. Defaults to
\code{2}.}

\item{transpose}{Logical. Makes variables appears as columns, and stats as rows.
Defaults to \code{FALSE}.}

\item{style}{Style to be used by \code{\link[pander]{pander}} when rendering
output tables; One of \dQuote{simple} (default), \dQuote{grid}, or
\dQuote{rmarkdown}.}

\item{plain.ascii}{Logical. \code{\link[pander]{pander}} argument; When
\code{TRUE}, no markup characters will be used (useful when printing
to console). Defaults to \code{TRUE} when \code{style} is \dQuote{simple},
and \code{FALSE} otherwise.}

\item{justify}{Alignment of columns; \dQuote{l} for left, \dQuote{c} for center,
or \dQuote{r} for right (default). Has no effect on \emph{html} tables.}

\item{omit.headings}{Logical. Set to \code{TRUE} to omit headings.}

\item{use.labels}{Logical. Display label instead of variable name when
label exists.}

\item{display.labels}{Logical. Should variable / data frame labels be displayed in
the title section?  Default is \code{TRUE}.}

\item{weights}{Vector of weights having same length as x. \code{NA}
(default) indicates that no weights are used.}

\item{rescale.weights}{Logical. When set to \code{TRUE}, the
total count will be the same as the unweighted \code{x}. \code{FALSE} by
default.}

\item{\dots}{Additional arguments passed to \code{\link[pander]{pander}}.}
}
\value{
A matrix object containing the statistics, with extra attributes used by
  \pkg{summarytool}'s print method.
}
\description{
Calculates mean, standard deviation, min, max, median, mad, IQR*, CV, 
skewness*, SE.skewness*, and kurtosis* on numerical vectors. (*) Not available 
when using sample weights.
}
\examples{
data(exams)
descr(exams)
descr(exams, transpose=TRUE)
descr(exams, stats = c("mean", "sd"))
data(tobacco)
with(tobacco, by(age, smoker, descr))

}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{univar}
