% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{freq}
\alias{freq}
\title{Frequency Tables for Factors and Other Discrete Data}
\usage{
freq(x, round.digits = 2, order = "names", style = "simple",
  plain.ascii = TRUE, justify = "default", omit.headings = FALSE,
  missing = "", display.type = TRUE, display.labels = TRUE,
  weights = NA, rescale.weights = FALSE, ...)
}
\arguments{
\item{x}{Factor or vector}

\item{round.digits}{Number of significant digits to display. Defaults
to \code{2}.}

\item{order}{Ordering of rows in frequency table; \dQuote{names} (default for
non-factors), \dQuote{levels} (default for factors), or \dQuote{freq}
(from most frequent to less frequent).}

\item{style}{Style to be used by \code{\link[pander]{pander}} when rendering
output table; One of \dQuote{simple} (default), \dQuote{grid} or
\dQuote{rmarkdown}.}

\item{plain.ascii}{Logical \code{\link[pander]{pander}} argument. When
\code{TRUE}, no markup characters will be used (useful when printing
to console). Defaults to \code{TRUE} when \code{style} is \dQuote{simple},
and \code{FALSE} otherwise.}

\item{justify}{String indicating alignment of columns. By default
(\dQuote{default}), \dQuote{right} is used for text tables and
\dQuote{center} is used for \emph{html} tables. You can force it to one
of \dQuote{left}, \dQuote{center}, or \dQuote{right}.}

\item{omit.headings}{Logical. Set to \code{TRUE} to omit headings.}

\item{missing}{Characters to display in NA cells. Defaults to \dQuote{}.}

\item{display.type}{Logical. Should variable type be displayed? Default is \code{TRUE}.}

\item{display.labels}{Logical. Should variable / data frame labels be displayed?
Default is \code{TRUE}.}

\item{weights}{Vector of weights; must be of the same length as \code{x}.}

\item{rescale.weights}{Logical parameter. When set to \code{TRUE}, the total
count will be the same as the unweighted \code{x}. \code{FALSE} by default.}

\item{\dots}{Additional arguments passed to \code{\link[pander]{pander}}.}
}
\value{
A frequency table of class \code{matrix} with added attributes used
  by the \emph{print} method.
}
\description{
Displays weighted or unweighted frequencies, including <NA> counts and
proportions.
}
\details{
The default \code{plain.ascii = TRUE} option is there to make results
  appear cleaner in the console. To avoid rmarkdown rendering problems, the
  option is automatically set to \code{FALSE} whenever
  \code{style = "rmarkdown"} (unless \code{plain.ascii = TRUE} is made
  explicit).
}
\examples{
data(tobacco)
freq(tobacco$gender)
freq(tobacco$gender, style="rmarkdown")
with(tobacco, by(smoker, gender, freq))

}
\seealso{
\code{\link[base]{table}}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{category}
\keyword{classes}
\keyword{univar}
