% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm25.R
\docType{data}
\name{bm25}
\alias{bm25}
\title{Best Matching(BM25)}
\format{\code{\link{R6Class}} object.}
\usage{
bm25
}
\description{
BM25 stands for Best Matching 25. It is widely using for ranking documents and a preferred method than TF*IDF scores.
It is used to find the similar documents from a corpus, given a new document. It is popularly used in information retrieval systems.
This implementation uses multiple cores for faster and parallel computation.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
bm25 = bm25$new(corpus, n_cores)
bm25$most_similar(input_document, topn)
bm25$compute(input_document)
}
}

\section{Methods}{

\describe{
  \item{\code{$new()}}{Initialise the instance of the class. Here you pass the complete corpus of the documents}
  \item{\code{$most_similar()}}{it returns the topn most similar documents from the corpus}
  \item{\code{$compute()}}{it returns a similarity score for all the documents in the corpus, given a sentence}
}
}

\section{Arguments}{

\describe{
 \item{corpus}{a list containing sentences}
 \item{use_parallel}{boolean value used to activate parallel computation, defaults to FALSE}
}
}

\examples{
example <- c('white audi 2.5 car','black shoes from office',
             'new mobile iphone 7','audi tyres audi a3',
             'nice audi bmw toyota corolla')
get_bm <- bm25$new(example, use_parallel=FALSE)
input_document <- c('white toyota corolla')
get_bm$most_similar(document = input_document, topn = 2)
}
\keyword{datasets}
