% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_50.r
\name{repam}
\alias{repam}
\title{Applies initial reparameterization for stable evaluation of the log determinant of the penalty matrix}
\usage{
repam(build)
}
\arguments{
\item{build}{object as returned by \code{\link{model.cons}}}
}
\value{
\item{build}{an object as returned by \code{\link{model.cons}}}
\item{X.ini}{initial design matrix (before reparameterization)}
\item{S.pen.ini}{initial penalty matrices}
}
\description{
Transforms the object from \code{\link{model.cons}} by applying the matrix reparameterization (matrix U.F). The reparameterization
is reversed at convergence by \code{\link{inv.repam}}.
}
\examples{

library(survPen)

# standard spline of time with 4 knots

data <- data.frame(time=seq(0,5,length=100),event=1,t0=0)

form <- ~ smf(time,knots=c(0,1,3,5))

t1 <- eval(substitute(time), data)
t0 <- eval(substitute(t0), data)
event <- eval(substitute(event), data)
	
# Setting up the model before fitting
model.c <- model.cons(form,lambda=0,data.spec=data,t1=t1,t1.name="time",
t0=rep(0,100),t0.name="t0",event=event,event.name="event",
expected=NULL,expected.name=NULL,type="overall",n.legendre=20,
cl="survPen(form,data,t1=time,event=event)",beta.ini=NULL)
 
# Reparameterization allows separating the parameters into unpenalized and 
# penalized ones for maximum numerical stability
re.model.c <- repam(model.c)

}
