% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{encToInt}
\alias{encToInt}
\title{Converts a character vector to an integer vector.}
\usage{
encToInt(x, encoding = localeToCharset())
}
\arguments{
\item{x}{Character vector}

\item{encoding}{A character string describing the encoding of x.  Defaults to the current locale.  See also \code{\link[=iconvlist]{iconvlist()}}}
}
\value{
An integer vector
}
\description{
Conversion of character vector to integer vector.  The encoding of the character vector can be specified but defaults to the current locale.
}
\examples{
encToInt("\xfa")
}
\seealso{
\code{\link[=iconv]{iconv()}}

Other Functions to clean data: 
\code{\link{fix_common_encoding_problems}()},
\code{\link{fix_levels_01_spss}()},
\code{\link{has_dont_know}()},
\code{\link{intToEnc}()},
\code{\link{leveltest}},
\code{\link{remove_all_dont_know}()},
\code{\link{remove_dont_know}()}
}
\concept{Functions to clean data}
\keyword{encoding}
