% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{sd_add_question}
\alias{sd_add_question}
\title{Add a Question Template to the Current Document}
\usage{
sd_add_question(type = "mc", id = NULL, label = NULL, chunk = FALSE)
}
\arguments{
\item{type}{A character string specifying the type of question template to
insert.
Default is \code{"mc"} (multiple choice). Available options are:
\itemize{
\item \code{"mc"}: Multiple choice (single selection)
\item \code{"select"}: Dropdown selection
\item \code{"mc_multiple"}: Multiple choice (multiple selections)
\item \code{"mc_buttons"}: Multiple choice with button layout (single selection)
\item \code{"mc_multiple_buttons"}: Multiple choice with button layout (multiple selections)
\item \code{"text"}: Short text input
\item \code{"textarea"}: Long text input
\item \code{"numeric"}: Numeric input
\item \code{"slider"}: Slider input
\item \code{"date"}: Date input
\item \code{"daterange"}: Date range input
}}

\item{id}{A character string specifying the ID for the question. If not provided,
a default ID based on the question type will be used. This ID should be unique
within your survey.}

\item{label}{A character string specifying the label (question text) to display
to respondents. If not provided, a default label placeholder will be used.}

\item{chunk}{Logical. If \code{TRUE}, the code will be generated with the R code
chunk wrapper. Defaults to \code{FALSE}.}
}
\value{
This function does not return a value. It modifies the active
document as a side effect by inserting text and potentially removing a
function call.
}
\description{
This function inserts a template for a surveydown question at the current
cursor position in the active RStudio document. It supports various question
types and automatically removes the function call before inserting the
template if it exists in the document.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks for and removes any existing \code{sd_add_question()} function call in the document.
\item Inserts the appropriate question template at the current cursor position.
\item If an ID is provided, replaces the default ID in the template with the provided ID.
\item If a label is provided, replaces the default label in the template with the provided label.
}
}
\examples{
if (interactive()) {
  library(surveydown)

  # Insert a default multiple choice question template
  sd_add_question()

  # Insert a text input question with custom ID and label
  sd_add_question("text", id = "user_email", label = "What is your email address?")

  # Insert a slider question template
  sd_add_question("slider", id = "satisfaction", label = "How satisfied were you with our service?")
}

}
