% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix_freq}
\alias{matrix_freq}
\title{Matrix Frequency Plot}
\usage{
matrix_freq(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The columns that contain each of the response options for a
question, can be selected by using \strong{tidyselect} semanatics or providing a
vector of column names or numbers}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
A ggplot2 object representing a grouped bar chart displaying the frequency distribution of responses
for the specified categorical variable. The chart supports grouping, weighting, and exclusion of subgroups.
}
\description{
Generate a grouped bar chart displaying the frequency distribution of
responses for a categorical variable. The function supports optional
subgrouping of data using the \code{group_by} variable, exclusion of specific
subgroups with 'subgroups_to_exclude,' and data weighting with the 'weights'
parameter. Users can also choose to exclude NA values from the questions
prior to analysis using the 'na.rm' parameter.
}
\examples{
 #Array question (1-5)
  matrix_freq(berlinbears, dplyr::starts_with('p_'))

  #remove NA category
  matrix_freq(berlinbears, dplyr::starts_with('p_'), na.rm = TRUE)

  #Use `group_by` to partition the question into several groups
  matrix_freq(berlinbears, dplyr::starts_with('p_'), group_by = species,
  subgroups_to_exclude = c('panda bear', NA ), na.rm = TRUE)

  #Categorical input
  matrix_freq(berlinbears, dplyr::starts_with('c_'), group_by = is_parent, na.rm = TRUE)



}
\seealso{
Other matrix questions: 
\code{\link{matrix_likert}()},
\code{\link{matrix_mean}()},
\code{\link{matrix_table}()}
}
\concept{matrix questions}
