% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{survival_data_frames}
\alias{survival_data_frames}
\title{Extract results from univariate survival analysis structured as data frames}
\usage{
survival_data_frames(result, format_numbers = TRUE, p_precision = 3,
  hr_precision = 2, p_less_than_cutoff = 0.001, time_precision = 1,
  timespan_unit = c("days", "months", "years"))
}
\arguments{
\item{result}{The result generated by \code{\link{analyse_survival}}}

\item{format_numbers}{If true, all numbers will be formatted for printing according to the following options
and will be returned as strings}

\item{p_precision, hr_precision, time_precision}{Precision with which to print floating point values}

\item{p_less_than_cutoff}{Cut-off for small p values. Values smaller than this will be displayed like "<..."}

\item{timespan_unit}{Unit for time spans: "days", "months" or "years".}
}
\value{
A named list list of data frame objects:\itemize{
        \item cohortMetadata: information about the full cohort
        \item if there are strata (analysis performed "by" a covariate): \itemize{
              \item strataMetadata: information about each stratum
              \item hazardRatios: hazard ratios for combinations of strata
              \item only if there are more than two strata: \itemize{
                    \item pairwisePValues: Matrix of pairwise (uncorrected) p values
              }
        }
   }
}
\description{
Extract results from univariate survival analysis structured as data frames
}
