% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survminertools.R
\name{kaplan_meier_plot}
\alias{kaplan_meier_plot}
\title{Kaplan Meier plots from survival results.}
\usage{
kaplan_meier_plot(..., mapped_plot_args = list(), p_lessthan_cutoff = 0.001)
}
\arguments{
\item{\dots}{One or many SurvivalAnalysisResult objects as returned by \code{\link{analyse_survival}} and
arguments that will be passed to ggsurvplot.
Bare lists will be spliced.
If using lists, the same argument may be contained in multiple lists;
in this case, the last occurrence is used, i.e. you can first pass a list
with default arguments, and then override some of them.
If you want to combine two curves in one plot (\code{\link[survminer]{ggsurvplot_combine}}), wrap
them in \code{\link{in_one_kaplan_meier_plot}} when passing as argument here.
(otherwise you will get a list with separate plots for each)
In addition to all arguments supported by \code{\link[survminer]{ggsurvplot}}, these arguments and shortcuts can be used additionally:
\itemize{
\item break.time.by: breakByYear, breakByHalfYear, breakByQuarterYear, breakByMonth (numeric value only in ggsurvplot)
\item xscale: scaleByYear, scaleByMonth (numeric value only in ggsurvplot)
\item hazard.ratio (logical): display hazard ratios in addition to p value, complementing pval=T
\item xlab: \{.OS,.PFS,.TTF,.DFS\}.\{years,months,days\}
\item table.layout: clean, displays risk table only with color code and number, no grid, axes or labels.
      (do not forget risk.table=TRUE to see something)
\item papersize: numeric vector of length 2, c(width, height), unit inches. kaplan_meier_plot
      will store a "papersize" attribute with this value which is read by \code{\link[tidytidbits]{save_pdf}}
\item ggplot.add: ggplot2 object to add to the ggplot plot part of the created KM plot.
      One common use case is manual specification of the line type, which is currently not possible with ggsurvplot.
      The passed object can be result of "+" operations will be added via "+" as usual with ggplot() objects.
}}

\item{mapped_plot_args}{Optionally, if given n objects to plot, a named list of vectors of size n.
The name is an argument names passed to ggsurvplot. The elements of the vector will be mapped 1:1 to each object.
This allows to perform batch plotting where only few arguments differ (e.g. titles A, B, C...) between the plots.}

\item{p_lessthan_cutoff}{The lower limit below which p value will be displayed as "less than".
If p_lessthan_cutoff == 0.001, the a p value of 0.002 will be displayed as is, while 0.0005 will become "p < 0.001".}
}
\value{
If given one result to plot, one ggsurvplot object; if given more than one result, a list of ggsurvplot objects.
}
\description{
Uses \code{\link[survminer]{ggsurvplot}} from the survminer package to create publication-ready plots.
}
\examples{
library(magrittr)
library(dplyr)
survival::aml \%>\%
  analyse_survival(vars(time, status), x) \%>\%
  kaplan_meier_plot(break.time.by="breakByMonth",
                    xlab=".OS.months",
                    risk.table=TRUE,
                    ggtheme=ggplot2::theme_bw(10))
}
