% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_keras.R
\name{build_keras_net}
\alias{build_keras_net}
\title{Build a Keras Multilayer Perceptron}
\usage{
build_keras_net(
  n_in,
  n_out,
  nodes = c(32L, 32L),
  layer_pars = list(),
  activation = "linear",
  act_pars = list(),
  dropout = 0.1,
  batch_norm = TRUE,
  batch_pars = list()
)
}
\arguments{
\item{n_in}{\code{(integer(1))}\cr Number of input features.}

\item{n_out}{\code{(integer(1))}\cr Number of targets.}

\item{nodes}{\code{(numeric())}\cr Hidden nodes in network, each element in vector represents number
of hidden nodes in respective layer.}

\item{layer_pars}{\code{(list())}\cr Arguments passed to \link[keras:layer_dense]{keras::layer_dense}.}

\item{activation}{\code{(character(1))}\cr Activation function passed to \link[keras:layer_activation]{keras::layer_activation}.
Default is linear.}

\item{act_pars}{\code{(list())}\cr Parameters for activation function, see
\link[keras:layer_activation]{keras::layer_activation}.}

\item{dropout}{\code{(numeric(1))}\cr Optional dropout layer, if \code{NULL} then no dropout layer added
otherwise either same dropout will be added to all layers.}

\item{batch_norm}{\code{(logical(1))}\cr If \code{TRUE} (default) then batch normalisation is applied
to all layers.}

\item{batch_pars}{\code{(list())}\cr Parameters for batch normalisation, see
\link[keras:layer_batch_normalization]{keras::layer_batch_normalization}.}
}
\description{
Utility function to build a Keras MLP.
}
\details{
This function is a helper for R users with less Python experience. Currently it is
limited to simple MLPs and with identical layers.
More advanced networks will require manual creation with \CRANpkg{keras}.
}
\examples{
\donttest{
if (requireNamespaces("keras")) {
  build_keras_net(4L, 2L)

  build_keras_net(n_in = 4L, n_out = 2L, nodes = c(32L, 64L, 32L),
    activation = "elu", dropout = 0.4)
}
}

}
