% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggforest.R
\name{ggforest}
\alias{ggforest}
\title{Drawing Forest Plot for CoxPH model}
\usage{
ggforest(model, alpha = 0.05, plot.title = "Forest plot for coxph model",
  ggtheme = theme_survminer(), palette = c("black", "red4"),
  xlab = "Hazard ratio", ...)
}
\arguments{
\item{model}{an object of class coxph.}

\item{alpha}{significance level for coloring.}

\item{plot.title}{legend title.}

\item{ggtheme}{function, ggplot2 theme name. Default value is theme_classic2. Allowed values include ggplot2 official themes: see theme.}

\item{palette}{the color palette to be used for coloring of significant variables.}

\item{xlab}{Label in OX axis.}

\item{...}{further arguments passed to the function \code{\link[ggpubr]{ggpar}} for customizing the plot.}
}
\value{
return an object of class ggplot
}
\description{
Drawing Forest Plot for CoxPH model
}
\examples{
require("survival")
model <- coxph( Surv(time, status) ~ sex + rx + adhere,
                data = colon )
ggforest(model)

}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
